<#--
 # This file is part of Fabric-Generator-MCreator.
 # Copyright (C) 2012-2020, Pylo
 # Copyright (C) 2020-2021, Pylo, opensource contributors
 # Copyright (C) 2020-2022, Goldorion, opensource contributors
 #
 # Fabric-Generator-MCreator is free software: you can redistribute it and/or modify
 # it under the terms of the GNU Lesser General Public License as published by
 # the Free Software Foundation, either version 3 of the License, or
 # (at your option) any later version.

 # Fabric-Generator-MCreator is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 # GNU Lesser General Public License for more details.
 #
 # You should have received a copy of the GNU Lesser General Public License
 # along with Fabric-Generator-MCreator.  If not, see <https://www.gnu.org/licenses/>.
-->

<#-- @formatter:off -->
<#include "procedures.java.ftl">

package ${package}.network;

import ${package}.${JavaModName};

public class ${name}Message extends FriendlyByteBuf {

	public ${name}Message(boolean isDown, boolean consumeClick) {
		super(Unpooled.buffer());
		writeBoolean(isDown);
		writeBoolean(consumeClick);
	}

    public static void apply(MinecraftServer server, ServerPlayer entity, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
        boolean isDown = buf.readBoolean();
        boolean consumeClick = buf.readBoolean();
        server.execute(() -> {
            Level world = entity.level;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();

            // security measure to prevent arbitrary chunk generation
            if (!world.hasChunkAt(entity.blockPosition()))
                return;

            <#if hasProcedure(data.onKeyPressed)>
                if(isDown) {
                    <@procedureOBJToCode data.onKeyPressed/>
                }
            </#if>

            <#if hasProcedure(data.onKeyReleased)>
                if(consumeClick) {
                    <@procedureOBJToCode data.onKeyReleased/>
                }
            </#if>
        });
    }
}
<#-- @formatter:on -->